import { Component, OnInit, Input } from '@angular/core';
import { NgRedux, select } from 'ng2-redux';
import { IAppState } from '../../../store';

import { ConceptServices } from '../../../services/concept-services';
import { MvpServices } from '../../../services/mvp-services';
import { RoleServices } from '../../../services/role-services';

interface AddMvpObject {
  conceptUri: string;
  // value: ;
  type: string;
}

@Component({
  selector: 'app-mvp-add',
  templateUrl: './mvp-add.component.html',
  styleUrls: ['./mvp-add.component.scss']
})
export class MvpAddComponent implements OnInit {
  @Input() tindex;
	@Input() mvpObject: AddMvpObject;
	//@select(['conceptSearch', 'selectedConcept']) selectedConcept;
	//@select(['conceptCard', 'conceptCardData']) conceptCardData;

  // set ngSwitch(mvpObject: )

  constructor(
  	private conceptServices: ConceptServices,
    public mvpServices: MvpServices,
    private roleServices: RoleServices,
  	private ngRedux: NgRedux<IAppState>) { }

  ngOnInit() {
    this.mvpObject.conceptUri = this.getState().conceptCard.conceptCardData.uri;
  }

  getState() {
  	return this.ngRedux.getState();
  }

  // conceptIsMvp() {
  // 	const allowlablePrefix = 'http://genisis.va.gov/mvp-schema#';
  // 	//return this.getState().conceptCard.conceptCardData.uri != null ? this.getState().conceptCard.conceptCardData.uri.indexOf(allowlablePrefix) > -1 : false
  // 	return true;
  // }

  hasMvpAddRole() {
    return this.roleServices.isTerminologist() && this.mvpServices.isConceptMvp();
  }
}
